﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VeteransAffairs.Registries.BusinessAHOBPR
{
    public class FirstGulfWarValidator : EligibilityValidator
    {
        public FirstGulfWarValidator(List<string> names, List<string> codes, DateRange dates): base(names, codes, dates) { }

        protected override bool DatesAreEligible(DateRange deployment)
        {
            return EligibleDates.Includes(deployment);
            //return ((deployment.Start >= Dates.Start && deployment.Start <= Dates.End)
            // || (deployment.End >= Dates.Start && deployment.End <= Dates.End));
        }
        protected override bool DatesAreEligible(REGISTRANT_DEPLOYMENT deployment)
        {

            return ((deployment.DEPLOYMENT_START_DATE >= EligibleDates.Start && deployment.DEPLOYMENT_START_DATE <= EligibleDates.End)
             || (deployment.DEPLOYMENT_END_DATE >= EligibleDates.Start && deployment.DEPLOYMENT_END_DATE <= EligibleDates.End));
        }
    }
}
